#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>


char buf[8092];
char pict[1024];
char text[1024];
char music[1024];
char tempo[1024];
char root[1024];
static int doLog = 0;

struct ids {
	uid_t uid;
	gid_t gid;
};

void getRealName(char *in, char *out) {
	*out = '\0';
	if ( *in )
	{
		while (*in)
		{
			if ( strncmp(in, "&39;",4) == 0 )
			{
				*out++ = '\'';
				in +=4;
			}
		 else
		 {
			*out++ = *in;
			in++;
		 }
	  }
	  *out = '\0';
	}
}

void smog(char *path, struct ids *ids, int isFile) {
	mode_t mod;
	if ( ids ) {
		chown(path, ids->uid,ids->gid);
		if ( isFile )
			mod = 0664;
		else
			mod = 0775;
		chmod(path, mod);
	}
}

void copy(char *elem, char *target, int skip, int isFile, struct ids *ids) {
	char buf[8092];
	int rd;
	char realName[1024];
	char targetRealName[1024];
	char *tok;
	char *tok2=NULL;
	FILE *log = NULL;
	if (!*elem)
		return;
	if ( doLog )
		log = fopen("log.txt","a");

	strcpy(targetRealName, target);

	getRealName(elem,realName);
	/* make all directories as needed */
	tok  = strtok(realName,"/");
	tok2 = strtok(NULL,"/");
	while ( tok2 )
	{
		strcat(targetRealName,"/");
		strcat(targetRealName,tok);
		mkdir(targetRealName,0777);
		smog(targetRealName, ids, 0);
		tok = tok2;
		tok2 = strtok(NULL,"/");
	}
	// copy the file
	strcpy(targetRealName, target);
	strcat(targetRealName,"/");
	getRealName(elem,realName);
	strcat(targetRealName,realName);

	if ( doLog ) {
		fprintf(log,"copy %s %s %d\n", elem,targetRealName,skip);
		fclose(log);
	}
	if ( skip ) {
		// check if we have to copy the source
		struct stat sts;
		struct stat stt;
		if ( stat(realName, &sts) != 0 ) {
//			fprintf(stderr,"failed\n");
			perror("stat");
			exit(1);
		}

		if ( stat(targetRealName, &stt) == 0 ) {
			if ( sts.st_size == stt.st_size ) {
				// files with same size, assume that
				// there are identical
//				fprintf(stderr,"skipped\n");
				return;
			}
		}
	}

	int in = open(realName,O_RDONLY);
	if ( in <=0 ) {
//		fprintf(stderr,"failed\n");
		fprintf(stderr,"Open %s O_RDONLY: %s\n",realName,strerror(in));
		exit(1);
	}
	int out = open(targetRealName,O_WRONLY|O_CREAT|O_TRUNC, 0666);
	if ( out <= 0) {
//		fprintf(stderr,"failed\n");
		fprintf(stderr,"Open %s O_WRONLY: %s\n",targetRealName,strerror(in));
		exit(1);
	}
	while ( (rd=read(in, buf, sizeof(buf))) > 0 ) {
		write(out,buf,rd);
	}
	close(in);
	close(out);
	smog(targetRealName,ids, isFile);
//	fprintf(stderr,"done\n");
}

void copyFonts(char *name, char *target, int isFile, struct ids *ids) {
	char line[1024];
	char font[1024];
	char *url;
	FILE *fp;

	if ( (fp=fopen(name,"r")) ) {
		while ( fgets(line, sizeof(buf),fp) ) {
			 if ( (url = strstr(line,"src: url(\"")) ) {
				strcpy(font,"textes/");
			//*font='\0';
				strcat(font,url+10);
				url = strchr(font,'"');
				if ( url  ) {
					*url='\0';
					copy(font,target, 1, isFile, ids);
				}
			}
		}
		fclose(fp);
	} else {
		perror("fopen (fonts)");
	}
}

char *getWord(char *in, char *out) {
	char *s, *e;
	s = strchr(in, '\'');
	*out = '\0';
	if ( s && *s ) {
		s++;
		e = strchr(s,'\'');
		if ( e >= s )
		{
			strncpy(out, s, e-s);
			out[e-s] ='\0';			
		}
	}
	if ( e && *e )
		e++;
	return e;
}
void scanLine(char* buf) {
	char *s = getWord(buf,pict);
	if ( s ) {
		s = getWord(s,text);
		s = getWord(s,music);
		s = getWord(s,tempo);
	}
}
int readValue(char *line, char*var) {
	char *s, *e;
	int ret = 0;
	s=strchr(line,'"');
	if ( s ) {
		s++;
		e=strchr(s,'"');
		if ( e ) {
			strncpy(var, s, (e-s));
			var[e-s]='\0';
			ret = 1;
		}
	}
	return ret;
}
struct ids * readConf(struct ids *ids) {
	FILE *fh = fopen("config.php","r");
	char uidn[512], gidn[512];
	char line[512];
	struct passwd *pwd = NULL;
	struct group *grp = NULL;
	char *s, *e;
	if ( fh ) {
		while ( fgets(line,sizeof(line),fh) ) {
			if ( strncmp("$user=\"",line,7) == 0 ) {
				if ( readValue(line,uidn) ) {
					pwd = getpwnam(uidn);
				}
			} else if ( strncmp("$group=\"",line,8) == 0 ) {
				if ( readValue(line,gidn) ) {
					grp = getgrnam(gidn);
				}
			} else if ( strncmp("$root=\"",line,7) == 0 ) {
				readValue(line,root);
			}
		}
		fclose(fh);
	}
	if ( pwd && grp ) {
		ids->uid = pwd->pw_uid;
		ids->gid = grp->gr_gid;
		return ids;
		setuid(pwd->pw_uid);
		setgid(grp->gr_gid);
	}
	return NULL;
}
void main(int argc, char **argv) {
	FILE *fp;
	char *targetDir = NULL;
	struct ids idss, *ids = NULL;
	struct stat st;

	if ( argc > 1 ) {
		if ( strcmp(argv[1],"-l") == 0 ) {
			doLog = 1;
			argc--;
			argv++;
		}
	}
	ids = readConf(&idss);
	if ( argc == 2 ) {
		targetDir = argv[1];
		if ( stat(targetDir, &st) == 0 ) {
			if ( !((S_IFDIR & st.st_mode) == S_IFDIR) ) {
				fprintf(stderr,"%s is not a directory", targetDir);
				exit(1);
			}
		} else {
			/* make the directory */
			mkdir(targetDir,0777);
			smog(targetDir, ids, 0);
		}
	} else {
		char *name;
		if ( (name=strrchr(argv[0],'/')) )
		{
			name++;
		}
		else
		{
			name = argv[0];
		}
		fprintf(stderr,"Syntax %s <target directory>\n",name);
		exit(1);
	}

   if ( (fp = fopen("list.js","r")) ) {
		*buf = '\0';
		while( fgets(buf, sizeof(buf), fp) ) {
			if ( strncmp(buf,"var", 3) == 0 )
				continue;
			if ( strncmp(buf,"];",2) == 0 )
				continue;
	   		*pict = *text = *music = '\0';
	   		scanLine(buf);
			copy(pict,targetDir,1,1, ids);
			copy(text,targetDir,0,1, ids);
			
			if ( *text ) {
				copyFonts(text, targetDir, 1, ids);
			} else {
				copy(text,targetDir,0,1, ids);
			}

			if ( strcmp(music,"-") ) {
				copy(music,targetDir,1,1, ids);
				char *str = strstr(music,".ogg");
				if ( str ) {
					strcpy(str,".mp3");
					copy(music,targetDir,1,1, ids);
	   			}
			}
			*buf = '\0';
		}
		fclose(fp);
		/* copy diashow.html, list.js start.png */
		/* if the file index.tmpl exist copy it to index.php */
		if ( stat("index.tmpl",&st ) == 0 ) {
			int err;
			copy("index.tmpl",targetDir,0,1, ids);
			char old[1024];
			sprintf(old,"%s/index.tmpl",targetDir);
			char ne[1024];
			sprintf(ne,"%s/index.php",targetDir);
			unlink(ne); /* delete index.php */

			err = link(old,ne);
			if (err) {
				perror("link");
				exit(1);
			}
			err = unlink(old);
			if (err) {
				perror("unlink");
				exit(1);
			}
		} else {
			copy("diashow.html",targetDir,0, 1, ids);
		}

		copy("list.js",targetDir,0,1, ids);
	} else {
		perror("fopen (list.js)");
		exit(1);
	}

	exit(0);
}
