<?php
	include("config.php");
	include ("data/export.php");
	function isForbidden($dir) {
		if ( $dir == 'fonts' ) return true;
		if ( $dir == 'data' ) return true;
		if ( $dir == 'fonts' ) return true;
		if ( $dir == 'music' ) return true;
		if ( $dir == 'textes' ) return true;
		if ( $dir == '.' ) return true;
		if ( $dir == '..' ) return true;
		return false;
	}

	function deleteObj($root,$name) {
		if ( is_dir("$root/$name") )
			rmdir("$root/$name");
		else
			unlink("$root/$name");
	}

	function moveObj($root,$oldName,$newName) {
		rename("$root/$oldName","$root/$newName");
	}

	function _getImgFiles($root, $dir) {
		$finfo=finfo_open(FILEINFO_MIME, null);
		$arr = [];
		if ($dh = opendir("$root/$dir")) {
			while (($file = readdir($dh)) !== false) {
				if ( $file == '.' || $file == '..' ) continue;
				if (  $dir == '' && is_dir("$root/$file") &&  isForbidden($file) ) continue;
				if ( $dir == '' && is_dir("$root/$file") ) {
					$arr = array_merge($arr, _getImgFiles($root, "$file"));
				} else if ( is_dir("$root/$dir/$file") ) {
					$arr = array_merge($arr, _getImgFiles($root, "$dir/$file"));
				} else {
					$ftype=finfo_file($finfo,  "$root/$dir/$file");
					if ( strpos($ftype,"image/png") === 0|| strpos($ftype,"image/jpeg") === 0 ) {
						if ( $dir == '' )
							$arr = array_merge($arr, [0=>"$file"]);
						else
							$arr = array_merge($arr, [0=>"$dir/$file"]);
					}
				}
			}
			closedir($dh);
		}
		finfo_close($finfo);
		return $arr;
	}
	function getImgFiles($root, $dir) {
		$arr = _getImgFiles($root,$dir);
		sort($arr);
		$count= count($arr);
		for ( $i = 0; $i < $count; $i++) {
			if ( $i == 0 )
				echo '<option selected value="'.$arr[$i].'">'.$arr[$i]."</option>\n";
			else
				echo '<option value="'.$arr[$i].'">'.$arr[$i]."</option>\n";
		}
		
	}

	function makeDir($root, $dir=null) {
		if ( $dir ) {
			$dir="$root/$dir";
			if ( ! file_exists($dir) )
				mkdir($dir, 0777, true);
		}
	}

	function saveHtml($root, $name=null) {
		if ( $name ) {
			$file="$root/$name";
			$fp = fopen($file,"w");
			fwrite($fp,$_POST['data']);
			fclose($fp);
		}
	}

	function loadHtml($root, $name=null) {
		$file="$root/$name";
		if (file_exists($file)) {
			header('Content-Description: File Transfer');
			header('Content-Type: text/html');
			header('Content-Disposition: attachment; filename='.basename($file));
			header('Content-Transfer-Encoding: utf8');
			header('Expires: 0');
			header('Cache-Control: must-revalidate');
			header('Pragma: public');
			header('Content-Length: ' . filesize($file));
			ob_clean();
			flush();
			readfile($file);
		}
	}

	function getDirList($root, $actDir, $subDir) {
		if ( $actDir == '' && $subDir == '..' ) {
			$subDir = '.';
		}
		$dir = $root . '/' . $actDir . '/' . $subDir;

		$newDir = '';
		if ( $subDir == '.' )
			$newDir=$actDir;
		else if ( $subDir == '..' ) {
			$p = strrpos($actDir,'/');
			if ( $p > 0 )
				$newDir = substr($actDir,0,$p);
			else
				$newDir='';
		} else {
			if ( $actDir == '' )
				$newDir = $subDir;
			else
				$newDir = "$actDir/$subDir";
		}

		$count=0;
		$dirList = [];
		if ($dh = opendir($dir)) {
			while (($entry = readdir($dh)) !== false) {
				if ( $entry == '.' || $entry == '..')
					continue;
				if ( isForbidden("$entry") ) continue;
				
				if ( is_dir($dir . '/' . $entry ) ) {
					$dirList[$count++] = $entry;
				}
			}
			closedir($dh);
			if ( $count > 0 )
				sort($dirList);
			$i;

			if ( $newDir == '' )
				$ret = "|.";
			else 
				$ret = "$newDir|..";
			for ( $i=0; $i < $count; $i++ )
				$ret = $ret . "|".$dirList[$i];
			echo "$ret";
		}
	}

	function uploadImg($root, $dir, $name, $img ) {		
		$pos = strripos($name, '.png');
		if ( $pos > 0 && strlen($name) == $pos + 4 )
			$img = str_replace('data:image/png;base64,', '', $img);
		else
			$img = str_replace('data:image/jpeg;base64,', '', $img);
		$img = str_replace(' ', '+', $img);
		$data = base64_decode($img);
		if ( $dir == '' )
			$file = "$root/$name";
		else
			$file = "$root/$dir/$name";
		$success = file_put_contents($file, $data);
		print $success ? $file : 'Unable to save the file.';
	}

	function getDirHtml($root, $dir) {
		$arr = [];
		if ($dh = opendir("$root/$dir")) {
			while (($file = readdir($dh)) !== false) {
				if ( $file == '.' || $file == '..' ) continue;
				if ( is_dir("$root/$dir/$file") ) continue;
				$pos = strstr($file, '.html');
				if ( $pos !== '.html' ) {
					continue;
				}
				$arr = array_merge($arr, [0=>"$file"]);
			}
			closedir($dh);
		}
		sort($arr);
		$count= count($arr);
		for ( $i = 0; $i < $count; $i++) {
			echo '<option value="'.$arr[$i].'">'.$arr[$i]."</option>\n";
		}
	}
	function rrmdir( string $path ) : void {
		if( trim( pathinfo( $path, PATHINFO_BASENAME ), '.' ) === '' )
			return;
		if( is_dir( $path ) )
		{
			array_map( 'rrmdir', glob( $path . DIRECTORY_SEPARATOR . '{,.}*', GLOB_BRACE | GLOB_NOSORT ) );
			rmdir( $path );
		} else {
			unlink( $path );
		}
	}
	function recurse_copy($src,$dst) { 
		$dir = opendir($src); 
		if ( !is_dir($dst) )
			mkdir($dst);
		if ($dir) {
			while(($file = readdir($dir)) !== false ) { 
				if (( $file != '.' ) && ( $file != '..' )) { 
					if ( is_dir($src . '/' . $file) ) { 
						recurse_copy($src . '/' . $file,$dst . '/' . $file); 
					}  else { 
						copy($src . '/' . $file,$dst . '/' . $file); 
					} 
				} 
			}
			closedir($dir); 
		} 
	}
 	function doExport($root, $target) {
		copyDS($root."/".$target);
	}
	function doImport($root, $source, $importopt = "") {
		// copy from source directory list.js
		copy($root."/".$source."/list.js","list.js");

		// Textes
		if ( strstr($importopt,'T') ) {
			$dh = opendir("textes");
			if ( $dh ) {
				while (($file = readdir($dh)) !== false) {
					if ( !is_dir($file) && stristr($file,'.html') ) {
						unlink("textes/".$file);
					}
				}
				closedir($dh);
			}
		}

		if ( stristr($importopt,'T') ) {
			$dh = opendir($root."/".$source."/textes");
			if ( $dh ) {
				while (($file = readdir($dh)) !== false) {
					if ( !is_dir($file) && stristr($file,'.html') ) {
						copy( $root."/".$source."/textes/".$file, "textes/".$file);
					}
				}
				closedir($dh);
			}
		}

		// Photograph
		if ( strstr($importopt,'P') ) {
			$dh = opendir(".");
			if ( $dh ) {
				while (($file = readdir($dh)) !== false) {
					if ( is_dir($file)  && !isForbidden($file) ) {
						rrmdir($file);
					}
				}
				closedir($dh);
			}
		}
		// copy image directories and picture back
		if ( stristr($importopt,'p') ) {
			$dh = opendir($root."/".$source);
			if ( $dh ) {
				while (($file = readdir($dh)) !== false) {

					if ( is_dir($root."/".$source."/".$file) ) {
						if ( !isForbidden($file) ) {
							recurse_copy($root."/".$source."/".$file, $file);
						}
					}
				}
				closedir($dh);
			}
		}
		// Music
		if ( strstr($importopt,'M') ) {
			rrmdir('music');
			mkdir('music');
		}
		if ( stristr($importopt,'m') ) {
			recurse_copy($root."/".$source."/music", "music");
		}
		// Fonts only import
		if ( stristr($importopt,'f') ) {
			$dh = opendir($root."/".$source."/textes/fonts");
			if ( $dh ) {
				while (($file = readdir($dh)) !== false) {
					if ( is_file($root."/".$source."/textes/fonts".$file) &&
					     ! is_file("textes/fonts/".$file) ) {
						copy($root."/".$source."textes/fonts".$file, "textes/fonts/".$file);
					}
				}
				closedir($dh);
			}
		}
	}
?>
