var styleh1 =       'color:#FF0000;';
styleh1 = styleh1 + 'margin:0em;margin-bottom:0em;';
styleh1 = styleh1 + 'text-shadow:#000000 0em 0em 0em;';
styleh1 = styleh1 + 'font-size:9em;';
styleh1 = styleh1 + 'font-family:YanoneKaffeesatz,sans-serif;';
styleh1 = styleh1 + 'display:block;';
styleh1 = styleh1 + '-webkit-transform:rotate(0deg);';
styleh1 = styleh1 + '-ms-transform:rotate(0deg);';
styleh1 = styleh1 + '-moz-transform:rotate(0deg);';
styleh1 = styleh1 + '-o-transform:rotate(0deg);';
styleh1 = styleh1 + 'transform:rotate(0deg);';
var title = 'Titel';
var styleh2 =       'color:#00FF00;';
styleh2 = styleh2 + 'margin:0em;margin-bottom:0em;';
styleh2 = styleh2 + 'text-shadow:#000000 0em 0em 0em;';
styleh2 = styleh2 + 'font-size:4.5em;';
styleh2 = styleh2 + 'font-family:YanoneKaffeesatz,sans-serif;';
styleh2 = styleh2 + 'display: block;';
styleh2 = styleh2 + '-webkit-transform:rotate(0deg);';
styleh2 = styleh2 + '-ms-transform:rotate(0deg);';
styleh2 = styleh2 + '-moz-transform:rotate(0deg);';
styleh2 = styleh2 + 'o-transform:rotate(0deg);';
styleh2 = styleh2 + 'transform:rotate(0deg);';
var subtitle = 'Untertitel';

var ed = {
	getTextStyle:	function (name) {
		url='?file='+name;
		var data = sendRequestData(url);
		return eval(data);
	},
	setTransformFromStyle: function(source) {
		var style = source.style;
		var val = null;
		var num = 0;
		if ( style.transform )       val = style.transform;
		if ( style.OTransform )      val = style.OTransform;
		if ( style.WebkitTransform ) val = style.WebkitTransform;
		if ( style.MozTransform )    val = style.MozTransform;
		if ( style.MsTransform )     val = style.MsTransform;
		if ( val ) {
			var vu = val.replace(/.*\((.*)\).*/, '$1');
			num = parseFloat(vu);
			if ( val.match(/.*rad/i) ) {
				num = num * 360 / 2 / 3.14159;
			}
		}
		return num;
	},
	getColorFromStyle: function (style) {
		var col = style; // default to original
		if ( style.match(/^rgb/) ) {
			var values = style.replace(/rgb\((.*)\)/, '$1');
			var r = parseInt(values).toString(16);
			if ( r.length == 1 ) r = '0'+r;
				var i = values.indexOf(',')+1;
			values =  values.substring(i,20);
			var g = parseInt(values).toString(16);
			if ( g.length == 1 ) g = '0'+g;
			i = values.indexOf(',')+1;
			values =  values.substring(i,20);
			var b = parseInt(values).toString(16);
			if ( b.length == 1 ) b = '0'+b;
			col = r+g+b;
		} else {
			col = col.replace(/#/,'');
		}
		return col;
	},
	getShadowsFromStyle: function (style) {
		values = new Array(4);
		var first;
		var last;
		var rgb = false;
		var xyr = '0 0 0';
		// color can be first or last element and be
		// stored as #xxxxxx or rgb(r,g,b)
		if ( style.match(/rgb/) ) {
			rgb = true;
			first = style.indexOf('r');
			last  = style.indexOf(')')+1;
		} else {
			// #xxx notation
			first = style.indexOf('#');
			if ( first <= 1 )
				last  = style.indexOf(' ',first);
			else
				last = style.length;
		}
		var color = style.substring(first,last);
		if ( first <= 1 ) {
				xyr = style.substring(last, style.length);
		} else {
			xyr = style.substring(0, first-1);
		}
		if ( rgb )
			values[3] = ed.getColorFromStyle(color);
		else
			values[3] = color.replace('#','');
		values[0] = parseFloat(xyr);
		xyr = xyr.substring(1, style.length);
		first=xyr.indexOf(' ');
		xyr = xyr.substring(first, style.length);
		values[1] = parseFloat(xyr);
		xyr = xyr.substring(1, style.length);
		first=xyr.indexOf(' ');
		xyr = xyr.substring(first, style.length);
		values[2] = parseFloat(xyr);
		return values;
	},
	showText: function (name) {
		var data = ed.getTextStyle(name);
		ed.fillText(data);
	},
	setSelectedFont: function(select, fontFamily) {
		fontFamily = fontFamily.replace(/,.*/g, '');
		for (var i = 0; i< select.options.length; i++) {
			if ( select.options[i].value == fontFamily ) {
				select.selectedIndex=i;
				break;
			}
		}
	},
	fillText: function (data) {
		if ( data ) {
			var target = document.getElementById('text');
			while (target.firstChild) {
				target.removeChild(target.firstChild);
			}
			target.innerHTML=data[0]+data[1];
			target.childNodes[0].id='h1';
			target.childNodes[1].id='h2';
			var h1 = target.childNodes[0];
			var h2 = target.childNodes[1];
			if ( h1 && target.childNodes[0].innerHTML == '' )
				target.childNodes[0].style.display='none';
			if ( h2 && target.childNodes[1].innerHTML == '' )
				target.childNodes[1].style.display='none';
			// fill input fields
			var color;
			var text = h1.innerHTML.replace(/&#39;/g,"'");
			text = text.replace(/&amp;/g,"&");
			document.forms.h1.text.value = text;
			ed.setSelectedFont(document.forms['h1'].family, h1.style.fontFamily);
			document.forms.h1.size.value = parseFloat(h1.style.fontSize);
			color = ed.getColorFromStyle(h1.style.color);
			document.forms.h1.color.style.backgroundColor = '#'+color;
			document.forms.h1.color.value = color;
			document.forms.h1.margin.value = parseFloat(h1.style.marginBottom);
			document.forms.h1.rot.value = ed.setTransformFromStyle(h1);
			var shadows1 = {};
			{
				// get style from cssStyle
				var text = data[0];
				var start = text.indexOf('text-shadow:');
				var end = text.indexOf(';',start);
				shadows1 = ed.getShadowsFromStyle(text.substring(start+12,end));
			}
			text = h2.innerHTML.replace(/&#39;/g,"'");
			text = text.replace(/&amp;/g,"&");
			document.forms.h2.text.value = text;
			ed.setSelectedFont(document.forms['h2'].family, h2.style.fontFamily);
			document.forms.h2.size.value = parseFloat(h2.style.fontSize);
			color = ed.getColorFromStyle(h2.style.color);
			document.forms.h2.color.style.backgroundColor = '#'+color;
			document.forms.h2.color.value = color;
			document.forms.h2.margin.value = parseFloat(h2.style.marginBottom);
			document.forms.h2.rot.value = ed.setTransformFromStyle(h2);
			var shadows2={};
			{
				var text = data[1];
				var start = text.indexOf('text-shadow:');
					var end = text.indexOf(';',start);
				shadows2 = ed.getShadowsFromStyle(text.substring(start+12,end));
			}
			document.forms.h1.x.value = shadows1[0];
			document.forms.h1.y.value = shadows1[1];
			document.forms.h1.r.value = shadows1[2];
			document.forms.h1.c.style.backgroundColor = '#'+shadows1[3];
			document.forms.h1.c.value = shadows1[3];
			document.forms.h2.x.value = shadows2[0];
			document.forms.h2.y.value = shadows2[1];
			document.forms.h2.r.value = shadows2[2];
			document.forms.h2.c.style.backgroundColor = '#'+shadows2[3];
			document.forms.h2.c.value = shadows2[3];

			ed.setFdSlider(document.forms.h1.size.value,'size1');
			ed.setFdSlider(document.forms.h2.size.value,'size2');
			ed.setFdSlider(document.forms.h1.rot.value,'rot1');
			ed.setFdSlider(document.forms.h2.rot.value,'rot2');
			ed.setFdSlider(document.forms.h1.margin.value,'margin1');
			ed.setFdSlider(document.forms.h1.margin.value,'margin2');
			ed.setFdSlider(document.forms.h1.x.value,'x1');
			ed.setFdSlider(document.forms.h1.y.value,'y1');
			ed.setFdSlider(document.forms.h1.r.value,'r1');
			ed.setFdSlider(document.forms.h2.x.value,'x2');
			ed.setFdSlider(document.forms.h2.y.value,'y2');
			ed.setFdSlider(document.forms.h2.r.value,'r2');
		}
	},
	setFdSlider: function (value, id) {
		fdSlider.updateSlider(id);
		var val = parseFloat(value);
		var max = parseFloat(document.getElementById(id).getAttribute('max'));
		if ( val >= max ) {
			fdSlider.stepDown(id,1);
			fdSlider.stepUp(id,1);
		} else {
			fdSlider.stepUp(id,1);
			fdSlider.stepDown(id,1);
		}
	},
	getStyles: function (form) {
		var text = 'color:#'+form.color.value+';';
		text = text +'font-family:'+form.family.value+';';
		text = text +'font-size:'+form.size.value+'em;';
		text = text +'transform:rotate('+form.rot.value+'deg);';
		text = text +'text-shadow:#'+form.c.value+' '+form.x.value+'em '+form.y.value+'em '+form.r.value+'em;';
		text = text +'margin-bottom:'+form.margin.value+'em;';
		return text;
	},
	saveDoc: function (name) {
		mode = 'new';
		if ( name == '' ) {
			alert(document.getElementById('noFileName').innerHTML);
		   return;
		}
		if ( name.indexOf('.html') < 0 ) {
			name=name+'.html'
		}
		if ( name.indexOf('textes/') == 0 ) {
			mode='edit';
			var sep = name.indexOf('/');
			name = name.substring(sep+1,name.length);
		}
		name = 'textes/'+name;
		var h1 = document.getElementById('h1');
		var h2 = document.getElementById('h2');
		var data={};
		data = ['?save='+name,'&title=','&css1=','&subtitle=','&css2='];
		if ( h1  ) {
			data[1] = data[1]+encodeURIComponent(h1.innerHTML);
			data[2] = data[2]+encodeURIComponent(ed.getStyles(document.forms.h1));
		}
		if ( h2 ) {
			data[3] = data[3]+encodeURIComponent(h2.innerHTML);
			data[4] = data[4]+encodeURIComponent(ed.getStyles(document.forms.h2));
		}
		var url = data[0]+data[1]+data[2]+data[3]+data[4];
		sendRequestData(url);
		cancel();
		if ( mode == 'new' ) {
			// create an element and put it to the temporary area
			putNewTextToTemp(name);
		}
	},
	setFamily: function (name, value) {
		document.getElementById(name).style.fontFamily=value;
	},
	_setRot: function (value) {
		return 'rotate('+value+'deg)';
	},
	setRot: function (name,value) {
		var e = document.getElementById(name);
		if ( !e ) return;
		var style=e.style;
		if ( !style ) return;
		if ( style.transform ) { style.transform = ed._setRot(value); }
		if ( style.WebkitTransform ) { style.WebkitTransform = ed._setRot(value); }
		if ( style.MozTransform ) { style.MozTransform = ed._setRot(value); }
		if ( style.OTransform ) { style.OTransform = ed._setRot(value); }
		if ( style.MsTransform ) { style.MStransform = ed._setRot(value); }
	},
	setSize: function (name,value) {
		if ( ! document.getElementById(name) ) return;
		document.getElementById(name).style.fontSize=value+'em';
	},
	setShadow: function (name,form, me,value) {
		var x = document.forms[form].x.value;
		var y = document.forms[form].y.value;
		var r = document.forms[form].r.value;
		var c = document.forms[form].c.value;
		var style = document.getElementById(name).style;
		style.textShadow = x+'em '+y+'em '+r+'em #'+c;
	},
	setTextColor: function (which, color) {
		var title = document.getElementById(which);
		title.style.color = '#'+color;
	},
	setText: function (name, text) {
		var elem = document.getElementById(name);
		elem.innerHTML=text;
		if ( text == '' ) {
			elem.style.display = 'none';
		} else {
			elem.style.display = 'block';
		}
		var i = 1;
	},
	setMargin: function (name, value) {
		var title = document.getElementById(name);
		//title.style.paddingTop = value+'em';
		title.style.marginBottom = value+'em';
	},
	setScreen: function (event, w) {
		// the screen may have the format:
		//   16:9  (1366/768)   682*384
		//   16:10 (1920x1200)  614*384
		//   15:9  (1280x768)   640*384
		//    4:3  (1024x768)   512*384
		//    5:3  (1280x1024)  480*384
		document.getElementById('viewContainer').style.width=w+'px';
		document.getElementById('imgDiv').style.width=w+'px';
		document.getElementById('text').style.width=w+'px';
		document.getElementById('img').style.maxWidth=w+'px';
	}
};
