<?php
	function getDirOptions($in) {
		// search for directories with pictures, target are
		// . and ./subdir
		$dir=opendir($in);
		if ( ! $dir ) die("can't open $in\n");
		while ( false !== ($d = readdir($dir)) ) {
			if ( $in == '.' && is_file($d) ) {
				continue;
			}
			if ( stristr($d,'jpg') || stristr($d,'html')) {
				echo "<option>$in</option>\n";
				break;
			}
		}
		rewinddir($dir);
		while ( false !== ($d = readdir($dir)) ) {
			if ( $d == '.' || $d == '..' || $d == 'data' ) {
				continue;
			}
			if ( $in == '.' && $d == 'doc' ) {
				continue;
			}
			if ( $in == '.' && is_dir($d) ) {
				getDirOptions($d);
			}
		}
		closedir($dir);
	}
	function buildFontFace($fontDir) {
		$hd = opendir($fontDir);
		$fontFace='';
		if ( $hd !== FALSE ) {
			while (($entry = readdir($hd))) {
				if ( strpos($entry,'.ttf') > 0 ) {
					$name=basename($entry, '.ttf');
					$text ="		@font-face {
			font-family: \"$name\";
			font-weight:bold;
			src: url(\"textes/fonts/$entry\") format(\"truetype\");
		}";
					$fontFace = "$fontFace\n$text";
				} else if ( strpos($entry,'.woff') > 0 ) {
					$name=basename($entry, '.woff');
					$text ="		@font-face {
			font-family: \"$name\";
			font-weight:bold;
			src: url(\"textes/fonts/$entry\") format(\"woff\");
		}";
					$fontFace = "$fontFace\n$text";
				}
			}
			
		}
		closedir($hd);
		return $fontFace;
	}
	function listFontFace($fontDir) {
		$hd = opendir($fontDir);
		$fontList='[';
		if ( $hd !== FALSE ) {
			while (($entry = readdir($hd))) {
				if ( strpos($entry,'.ttf') > 0 ) {
					$name=basename($entry, '.ttf');
					if ( $fontList != '[' ) {
						$fontList = $fontList.",";
					}
					$fontList = $fontList."'$name'";
				}
			}
		}
		closedir($hd);
		return $fontList.'];';
	}
	function setFamily($fontDir) {
		$hd = opendir($fontDir);
		$list = array();
		$i=0;
		if ( $hd !== FALSE ) {
			while (($entry = readdir($hd))) {
				if ( strpos($entry,'.ttf') > 0 ) {
					$name=basename($entry, '.ttf');
					$list[$i++] = $name;
				}
			}
		}
		$count=count($list);
		closedir($hd);
		sort($list);
		for ( $i=0; $i<$count; $i++) {
			echo "<option value=\"$list[$i]\">$list[$i]</option>\n";
		}
	}
	// write big list.js file
	function buildList($fileName, $command, $arg) {
		$status = 'OK';
		if ( $command == 'open' ) {
			$hd = fopen($fileName,"w");
			if ( $hd === FALSE ) {
				$status = "Open $fileName failed";
			} else {
				fwrite($hd,"var fileList = [\n");
				fclose($hd);
			}
		}
		else if ( $command =='append' ) {
			$data= str_replace("],", "],\n",$arg);
			$data= str_replace("&amp;", "&",$data);
			$hd = fopen($fileName,"a");
			if ( $hd === FALSE ) {
				$status = "Append $fileName failed";
			} else {
				fwrite($hd,$data);
				fclose($hd);
			}
		}
		else if ( $command == 'close' ) {
			$hd = fopen($fileName,"a");
			if ( $hd === FALSE ) {
				$status = "Close $fileName failed";
			} else {
				fwrite($hd,"];\n");
				fclose($hd);
			}
		}
		else {
			$status = "$command Unknown";
		}
		header("Content-Type: text/plain;charset=UTF-8");
		echo $status;
	}
	function writeList($fileName,$content) {
		$data= str_replace("],", "],\n",$content);
		$data= str_replace("&amp;", "&",$data);
		$f = fopen($fileName,"w");
		fwrite($f,"var fileList = [\n");
		fwrite($f,$data);
		fwrite($f,"];\n");
		fclose($f);
		header("Content-Type: text/plain;charset=UTF-8");
		echo 'OK';
	}
	function readJs($name) {
		$hd = fopen($name,"rb");
		if ( $hd ) {
			$content = fread($hd, filesize($name));
			$pos = strpos($content,'[');
			echo substr($content,$pos);
			fclose($hd);
		}
	}
	function getImage($name,$size) {
		$img = imagecreatefromjpeg($name);
		header("Content-Type: image/jpeg");
		if(!empty($size)) {
			list($w,$h) = getimagesize($name);
			if( $w==0 or $h==0 ) die("ERROR - zero image size");
			$percent = $size / (($w>$h)?$w:$h);
			if($percent>0 and $percent<1) {
				$nw = intval($w*$percent);
				$nh = intval($h*$percent);
				$img_resized = ImageCreateTrueColor($nw,$nh);
				if(imagecopyresized($img_resized,$img, 0,0,0,0, $nw,$nh, $w,$h )) {
					imagedestroy($img);
					$img = $img_resized;
				}
			}
		}
		imagejpeg($img);
		imagedestroy($img);
	}
	function _getPictList($dir) {
		$hd = opendir($dir);
		echo '[';
		$files=Array();
		while ( false !== ($file = readdir($hd)) ) {
			$file = str_replace("'","&39;",$file);
			if ( !is_dir($file) && stristr($file,'.jpg') ) {
				if ( $dir != '.' ) {
					$file = "$dir/$file";
				}
//				echo "['$file','','',''],";
				array_push($files,$file);
			}
		}
		sort($files);
		foreach ($files as $file ) {
			echo "['$file','','',''],";
		}
		echo '];';
		closedir($hd);
	}
	function _getTextList($dir) {
		$hd = opendir($dir);
		$list = array();
		$i = 0;
		while ( false !== ($file = readdir($hd)) ) {
			if ( !is_dir($file) && stristr($file,'.html') ) {
				$list[$i++] = $file;
			}
		}
		closedir($hd);
		sort($list);
		$count=count($list);
		echo '[';
			for ( $i=0; $i < $count; $i++) {
				$name = str_replace("'","&39;", $list[$i]);
				echo "['','textes/$name','','']";
				if ( $i < $count-1 )
					echo ",";
			}
		echo '];';
	}
	function getPictList($dir) {
		header("Content-Type: text/plain;charset=UTF-8");
		if ( $dir != 'textes' ) { 
			_getPictList($dir);
		} else {
			_getTextList($dir);
		}
	}

	function _getFileList($dir, $ext) {
		$hd = opendir($dir);
		$list = array();
		$i = 0;
		if (!$hd) {
			return $list;
		}
		while ( false !== ($file = readdir($hd)) ) {
			if ( $file == '.' || $file == '..' ) {
				continue;
			}
			if ( $dir != '.' ) {
				$name = "$dir/$file";
			} else {
				$name = $file;
			}
			if ( !is_dir($file) && stristr($file,$ext) ) {
				$list[$i++] = $name;
			} else if ( is_dir($name) ) {
				$lists= _getFileList("$name", $ext);
				foreach($lists as $l) {
					$list[$i++] = $l;
				}
			}
		}
		closedir($hd);
		return $list;
	}
	function getFileList($dir,$ext) {
		header("Content-Type: text/plain;charset=UTF-8");
		echo '[';
		$list = _getFileList($dir, $ext);
		$i = 0;
		$count = count($list);
		sort($list);
		for ($i = 0; $i < $count; $i++ ) {
			$name = str_replace("'","&39;", $list[$i]);
			echo "'$name'";
			if ( $i < $count-1 )
				echo ",";
		}
		echo '];';
	}
	function getTagText($tag, $line) {
		$start = strpos($line,'>');
		$start += 1;
		$end = strpos($line,"</$tag>");
		$text = substr($line,$start,$end-$start);
		$text = preg_replace("/'/","&#39;",$text);
		return $text;
	}
	function getStyle(&$style, $line, $hd) {
		$words = preg_split("/[ \t:{]+/", $line,NULL,PREG_SPLIT_NO_EMPTY);
		if ($words[0]=='') return;
		foreach ( $style as $class => $value ){
			if ( ".$class" == $words[0] ){
				// class found
				$line = fgets($hd);
				// split line into each word with delim : and ;
				$words = preg_split("/[\t :;]+/", $line,NULL,PREG_SPLIT_NO_EMPTY);
				$nb = count($words) -1;
				$st="$words[0]: ".$words[1];
				$i=2;
				while ( $i<$nb ) {
					$st .= ' '.$words[$i];
					$i++;
				}
				$st .= ";";
				$style[$class] = $st;
				while ( ($line = fgets($hd)) !== FALSE) {
					if ( strpos($line,'}') !== FALSE ){
						break;
					}
				}
				return;
			}
		}
	}
	function getTextStyle($name) {
		$title='';
		$subtitle='';
		$style = array(
			'color1'  => 'color:#ff0000;',
			'color2'  => 'color:#00ff00;',
			'rot1'    => 'transform:rotate(0deg);',
			'rot2'    => 'transform:rotate(0deg);',
			'margin1' => 'margin:0em 0em 0em 0em;',
			'margin2' => 'margin:0em 0em 0em 0em;',
			'shadow1' => 'text-shadow:#ffffff 0em 0em 0em;',
			'shadow2' => 'text-shadow:#ffffff 0em 0em 0em;',
			'size1'   => 'font-size:9em;',
			'family1' => 'font-family:YanoneKaffeesatz-Bold;',
			'size2'   => 'font-size:4.5em;',
			'family2' => 'font-family:YanoneKaffeesatz-Bold;'
		);
		$hd = fopen($name,"r");
		if ( !$hd ) die("Can't read $name");
			$content='';
		$inStyle = FALSE;
		$inBody  = FALSE;
		while ( ($line = fgets($hd)) !== false ) {
			if ( (strpos($line,'</style>')) !== FALSE ) {
				$inStyle = FALSE;
				continue;
			}
			if ( (strpos($line,'<style ')) !== FALSE ) {
				$inStyle = TRUE;
				continue;
			}
			if ( (strpos($line,'<body')) !== FALSE ) {
				$inBody = TRUE;
				continue;
			}
			if ( (strpos($line,'</body>')) !== FALSE ) {
				$inBody = FALSE;
				continue;
			}
			if ( $inBody ) {
				if ( strpos($line,'<h1') !== FALSE ) {
					$title = getTagText('h1', $line);
				}
				if ( strpos($line,'<h2') !== FALSE ) {
					$subtitle = getTagText('h2', $line);
				}
			}
			if ( $inStyle ) {
				getStyle($style, $line, $hd);
			}
		}
		fclose($hd);
		header("Content-Type: text/plain;charset=UTF-8");
		echo "['<h1 style=\"$style[color1]$style[margin1]$style[shadow1]";
		echo "$style[rot1]-ms-$style[rot1]-webkit-$style[rot1]-moz-$style[rot1]-o-$style[rot1]";
		echo "$style[size1]$style[family1]display:block;\">$title</h1>',";
		echo "'<h2 style=\"$style[color2]$style[margin2]$style[shadow2]";
		echo "$style[rot2]-ms-$style[rot2]-webkit-$style[rot2]-moz-$style[rot2]-o-$style[rot2]";
		echo "$style[size2]$style[family2]display:block;\">$subtitle</h2>'];";
	}
function logIt($text) {
$hdl=fopen("log.txt", "a");
fwrite($hdl,$text."\n");
fclose($hdl);
}

	function fillCssArray(&$styles, $css) {
		$css = preg_replace('/-moz-|-webkit-|-ms-|-o-/','',$css);
		$vals = explode(';',$css);
		foreach ($vals as $val) {
			$a = explode(':',$val);
			$a[0] = preg_replace('/[- ]/','',$a[0]);
			if ( $a[0] === '' ) continue;
			$a[1] = preg_replace('/^[ ]+/','',$a[1]);
			if ( isset($styles[$a[0]]) ) {
				if ( strpos($a[1],'rad') > 0 ) {
					$v = preg_replace('/.*\((.*)rad\).*/', '$1', $a[1]);
					$v = round($v * 360 / 2 / 3.14159);
					$styles[$a[0]] = "rotate(${v}deg)";
				}
				else
				{
					$styles[$a[0]] = $a[1];
				}
			}
		}		
	}
	function saveText($name, $title, $css1, $subtitle, $css2, $fontdir) {
		$style1 = array(
			'color'        => '#ff0000',
			'transform'    => 'rotate(0deg)',
			'marginbottom' => '0em',
			'textshadow'   => '#000000 0em 0em 0em',
			'fontsize'     => '9em',
			'fontfamily'   => 'YanoneKaffeesatz-Bold'
		);
		$style2 = array(
			'color'        => '#00ff00',
			'transform'    => 'rotate(0deg)',
			'marginbottom' => '0em',
			'textshadow'   => '#000000 0em 0em 0em',
			'fontsize'     => '4.5em',
			'fontfamily'   => 'YanoneKaffeesatz-Bold'
		);

		fillCssArray($style1, $css1);
		fillCssArray($style2, $css2);
		if ( $fontdir != "" ) {
			$fonts=$fontdir;
		} else {
			$fonts="fonts";
		}
		$content="<!DOCTYPE html>
<html lang=\"de\">
	<head>
		<title>Titel der Seite</title>
		<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">
		<style type=\"text/css\">
			@font-face {
				font-family:".$style1['fontfamily'].";
				font-weight:bold;
				src: url(\"".$fonts."/". $style1['fontfamily'].".ttf\") format(\"truetype\");
			}
			@font-face {
				font-family:".$style2['fontfamily'].";
				font-weight:bold;
				src: url(\"".$fonts."/". $style2['fontfamily'].".ttf\") format(\"truetype\");
			}
			/* Schrift Familie und default Größe festlegen */
			body {
				font-family: YanoneKaffeesatz, sans-serif;
				font-size: 100%;
				margin:0;
				padding:0;
				line-height: 1.2;
			}
			.table {
				width:100%;
				height:100%;
				display:table;
				overflow:hidden;
			}
			.cell {
				display:table-cell;
				vertical-align: middle;
				text-align:center;
			}
			/* Einige Werte für die Standard HTML elemente (um)definieren */
			h1, h2 {
				text-align:center;
				margin:0;
				padding:0;
			}
			/* Klassen deklarieren */
			.size1 {
				font-size:".$style1['fontsize'].";
			}
			.family1 {
				font-family:".$style1['fontfamily'].";
			}
			.rot1 {
				transform: ".$style1['transform'].";
				-webkit-transform:".$style1['transform'].";
				-moz-transform:".$style1['transform'].";
				-o-transform:". $style1['transform'].";
				-ms-transform:".$style1['transform'].";
			}
			.shadow1 {
				text-shadow:".$style1['textshadow'].";
			}
			.color1 {
				color:".$style1['color'].";
			}
			.margin1 {
				margin-bottom:".$style1['marginbottom'].";
			}
			.size2 {
				font-size:".$style2['fontsize'].";
			}
			.family2 {
				font-family:".$style2['fontfamily'].";
			}
			.rot2 {
				transform: ".$style2['transform'].";
				-webkit-transform:".$style2['transform'].";
				-moz-transform:".$style2['transform'].";
				-o-transform:". $style2['transform'].";
				-ms-transform:".$style2['transform'].";
			}
			.shadow2 {
				text-shadow:".$style2['textshadow'].";
			}
			.color2 {
				color:".$style2['color'].";
			}
			.margin2 {
				margin-bottom:".$style2['marginbottom'].";
			}
			</style>
			<script type=\"text/javascript\">
			function setValues() {
				var container = document.getElementById(\"container\");
				var h = window.innerHeight;
				container.style.height = h+'px';
				var fh = (h/768)*16;
				document.body.style.fontSize = fh+'px';
				document.body.style.fontSize = fh+'px';
				var head = document.getElementById('h1')
				if ( head.innerHTML=='' ) {
					head.style='none';
				}
				head = document.getElementById('h2')
				if ( head.innerHTML=='' ) {
					head.style='none';
				}
			}
		</script>
	</head>
	<body onload=\"setValues();\" onresize=\"setValues();\">
		<div id=\"container\" class=\"table\">
			<div class=\"cell\">
				<h1 id=\"h1\" class=\"color1 shadow1 rot1 margin1 size1 family1\" style=\"display:block;\">".$title."</h1>
				<h2 id=\"h2\" class=\"color2 shadow2 rot2 margin2 size2 family2\" style=\"display:block;\">".$subtitle."</h2>
			</div>
		</div>
	</body>
</html>";
		$hd = fopen($name,"w");
		fwrite($hd,$content."\n");
		fclose($hd);
	}
?>
