var fileList = null;
var waitTime = 5000;
var PICT  = 0;
var TEXT  = 1;
var SOUND = 2;
var DT    = 3;
function appendPlaceHolder(target) {
	var topDiv = document.createElement('div');
	topDiv.id='dropHolder';
	topDiv.setAttribute('ondragover','return dragOver(event)');
	topDiv.setAttribute('ondrop','return dragDrop(event)');
	if ( window.opera ) {
		document.addEventListener('dragOver',dragOver,false);
		document.addEventListener('dragEnter',dragEnter,false);
	}
	target.appendChild(topDiv);
}
function buildDragableElement(listElem, target, before) {
	var topDiv = document.createElement('div');
	topDiv.setAttribute('draggable',true)
	topDiv.addEventListener('dragstart',dragStart,true);
	if ( target.id == 'show' ) {
		topDiv.setAttribute('ondragover','return dragOver(event)');
		topDiv.setAttribute('ondrop','return dragDrop(event)');
	}
	topDiv.addEventListener('dblclick',edit,true);
	topDiv.addEventListener('mousedown',editText,true);
	if ( before ) {
		target.insertBefore(topDiv,before);
	} else {
		target.appendChild(topDiv);
	}
	if ( listElem[PICT]!='' ) {
		var img = document.createElement('img');
		var tmp=listElem[PICT].replace(/&amp;/g,'&');
		tmp=tmp.replace(/&#39;/g,"'");
		img.src='edit.php?id='+encodeURIComponent(tmp)+'&size=200';
		img.draggable = false;
		img.setAttribute('class','pict');
		topDiv.appendChild(img);
		var div = document.createElement('div');
		div.setAttribute('class','pictName');
		div.innerHTML = listElem[PICT];
		topDiv.setAttribute('alt',tmp);
		topDiv.setAttribute('title',tmp);
		topDiv.appendChild(div);
	} else {
		var div = document.createElement('div');
		div.innerHTML = listElem[PICT];
		div.setAttribute('class','pict');
		topDiv.appendChild(div);
		div = document.createElement('div');
		div.setAttribute('class','pictName');
		div.innerHTML = listElem[PICT];
		topDiv.appendChild(div);
	}
	{
		var div = document.createElement('div');
		div.setAttribute('class','text');
		div.innerHTML = listElem[TEXT];
		topDiv.appendChild(div);
	}
	{
		var div = document.createElement('div');
		div.innerHTML = listElem[SOUND];
		div.setAttribute('class','sound');
		topDiv.appendChild(div);
	}
	{
		var div = document.createElement('div');
		div.innerHTML = listElem[DT];
		div.setAttribute('class','time');
		topDiv.appendChild(div);
	}
}
function setMainHeight() {
	document.getElementById('mainDiv').style.height=window.innerHeight+'px';
}
function init() {
	initMode();
	// initialize first fd-slider
	fdSlider.onDomReady();
	if ( ! fileList ) {
		var data = sendRequestData('?read=list.js');
		if ( data != '' ) {
			fileList = eval(data);
		}
	}
	var show = document.getElementById('show');
	var i;
	for ( i = 0; fileList && i < fileList.length; i++) {
		if ( fileList[i] && (fileList[i][0] || fileList[i][0] ===''))
		{
			/* add elements if required */
			var j;
			for ( j=1;j <= DT; j++ ) {
				if ( !fileList[i][j] ) {
					fileList[i][j] = '';
				}
			}
			buildDragableElement(fileList[i], show, null);
		} else { // remove empty/undefined elements
			fileList.splice(i, 1);
			i--;
		}
	}
	// place holder for an empty show area
	appendPlaceHolder(show);
	i++;
	show.style.width=(216*i)+8+'px';
	if ( window.opera ) {
		document.addEventListener('dragover',dragOver,false);
		document.addEventListener('drop',dragDrop,false);
		document.addEventListener('dragenter',dragEnter,true);
		document.addEventListener('dragleave',dragLeave,false);
		document.addEventListener('dragstart',dragStart,false);
	}
	// set language
	var lang = document.getElementsByTagName('html')[0].getAttribute('lang');
	if ( lang ) {
		// set selected language
		var elem = document.getElementById('languages')
		for ( var i = 0; i < elem.options.length;i++ ) {
			if ( elem.options[i].value == lang ) {
				elem.selectedIndex=i;
				break;
			}
		}
		if ( i == elem.options.length )
			lang='en';
		setLang(null,lang);
	}
	setMainHeight();
	// Hide the "window" with fd-slider
	document.getElementById('textMainContainer').style.display = 'none';
}
window.addEventListener('load',init,false);
// for firefox if we have a selection!
window.addEventListener('mousedown', deselectAll,true);
function buildItemsString(elem) {
	var items='[';
	var txt;
	var j;
	for ( j = 1; j < 5; j++ ) {
		var child = elem.children[j];
		if ( child && child.innerHTML && child.innerHTML !== '' ) {
			txt = items;
			items = txt+"'"+child.innerHTML+"'";
		} else {
			txt = items;
			items = txt+"''";
		}
		if ( j < 4 ) {
			txt = items;
			items = txt+",";
		}
	}
	txt = items;
	items = txt+'];';
	return items;
}
function sendRequestData(url)
{
	var xmlHttp = new XMLHttpRequest();
	xmlHttp.open( 'GET', 'edit.php'+url, false );
	xmlHttp.setRequestHeader("Content-Type", "text/plain");
	xmlHttp.send(null);
	for(;;) {
		if ( xmlHttp.readyState == 4 ) {
			if( xmlHttp.status == 200 ) {
				return xmlHttp.responseText;
			} else {
				alert( 'Status '+  xmlHttp.status +' '+xmlHttp.responseText);
				return "";
			}
		}
	}
	return "";
}
function newDia() {
	/* remove element from show div */
	var show = document.getElementById('show');
	while ( show.firstChild != show.lastChild) {
		show.removeChild(show.firstChild)
	}
	fileList = eval('[];');
	saveList();
}
function saveList() {
	var show=document.getElementById('show');
	var children = show.children;
	var i = 0;
	var data = '';
	for (i=0; i< children.length-1;i++) {
		var j;
		data += '[';
		for ( j = 1; j < 5; j++ ) {
			var dt = children[i].children[j];
			if ( dt && dt.innerHTML && dt.innerHTML !== '' ) {
				var tmp = dt.innerHTML;
				tmp.replace(/&amp;/g,"\&");
				tmp.replace(/&#39;/g,"'");
				data += "'"+tmp+"'";
			}
			else {
				data += "''";
			}
			if ( j < 4 ) {
				data += ",";
			}
		}
		data += '],';
	}
	if ( data.length < 2048 ) {
		var result = sendRequestData("?list="+encodeURIComponent(data));
	} else {
		result = sendRequestData("?open=open");
		if ( result != "OK" ) return false;
		var pos = 0;
		var len = data.length;
		var sendSize = 1024;
		var encoded = '';
		while ( pos < len ) {
			if ( (len - pos) < sendSize ) sendSize =  len - pos;
			encoded=encodeURIComponent(data.substring(pos,pos+sendSize));
			result = sendRequestData("?append="+encoded);
			pos += sendSize;
			if ( result != "OK" ) return false;
		}
		result = sendRequestData("?close=close");
	}
	if ( result == "OK" ) {
		return true;
	}
	return false;
}
function editText(ev) {
	if ( ev.ctrlKey || ev.which >= 2) {
		// get real target if any
		var top = ev.target;
		while ( top.parentNode ) {
			if ( top.parentNode.id == 'show' || top.parentNode.id == 'dropHolder'||top.parentNode.id ==  'dir') {
				if ( top.getAttribute('draggable') ) {
					if ( top.childNodes.length == 5 ) {
						if ( top.childNodes[2].innerHTML != '' ) {
							top.setAttribute('id','editObject');
							doText(ev,top.childNodes[2].innerHTML, top.childNodes[1].innerHTML);
							break;
						}
					}
				}
			}
			top = top.parentNode;
		}
	}
	return true;
}
// for firefox : if we have selections we will get one
// subelement of the dragable object and all selected textes/images!

		function deselectAll(ev) {
			if (window.getSelection) {
				if (window.getSelection().empty) {  // Chrome
					window.getSelection().empty();
				} else if (window.getSelection().removeAllRanges) {  // Firefox
					window.getSelection().removeAllRanges();
				}
			} else if (document.selection) {  // IE?
				document.selection.empty();
			}
			return true;
		}
		function dragStart(ev) {
			var dragged = document.getElementById('dragged');
			if ( dragged ) {
				dragged.removeAttribute('id');
				dragged.removeAttribute('datas');
			}
			ev.dataTransfer.clearData();
			ev.dataTransfer.effectAllowed='copy';
			var txt = buildItemsString(ev.target);
			// don't use setData as usual, we will fail on Firefox
			ev.dataTransfer.setData("text/plain",'');
			var x = ev.target.clientWidth / 2;
			var y = ev.target.clientHeight /2;
			ev.dataTransfer.setDragImage(ev.target,x,y);
			ev.target.setAttribute('id','dragged');
			ev.target.setAttribute('datas',txt);
			return true;
		}
		function dragOver(ev) {
			ev.preventDefault();
			ev.stopPropagation();
			ev.dataTransfer.dropEffect = 'copy';
			return false;
		}
		function dragEnter(ev) { /* for Opera */
			var dragged = document.getElementById('dragged');
			var target = ev.target;
			// check if we have a valid anchestor
			while ( target && target.parentNode )
			{
				if ( target.id == 'tmp' || target.id == 'trash' || target.id == 'dropHolder' ) {
					ev.preventDefault();
					ev.stopPropagation();
					return true;
				}
				if ( target.parentNode.id == 'tmp' && target !== dragged ) {
					ev.preventDefault();
					ev.stopPropagation();
					return true;
				}
				if ( target.parentNode.id == 'show' && target !== dragged )
				{
					ev.preventDefault();
					ev.stopPropagation();
					return true;
				}
				target = target.parentNode
			}
			return false;
		}
		function dragLeave(ev) { /* for Opera */
			ev.preventDefault();
			ev.stopPropagation();
			return true;
		}
		function dragEnd(ev) {
			ev.preventDefault();
			ev.stopPropagation();
		}
		function dragDrop(ev) {
			if ( ev.type == 'mousedown' ) return true;
			var top;
			var before = null;
			var dragged = document.getElementById('dragged');
			ev.preventDefault();
			ev.stopPropagation();
			if ( dragged == null ) {
				return false;
			}
			if ( ev.target.id == 'dragged' ) {
				dragged.removeAttribute('id'); //ev.target.id == '';
				return false;
			}
			// search the real target which may have the id tmp, dropHolder,
			// show or be itself (attribute draggable) on the show area
			top = ev.target;
			while ( top.parentNode ) {
				var id = top.id
				if ( id == 'dragged' ) {
					return false; // ourself
				
				} else if ( id == 'trash' ) {
					before = null;
					break;
				} else if (id == 'tmp' ) {
					before = null;
					break;
				} else if ( top.parentNode.id == 'show' ) {
					before  = top;
					top = top.parentNode;
					break;
				} else if ( id == 'dropHolder' ) {
					before = top;
					top = top.parentNode;
					break;
				}
				top = top.parentNode;
			}
			var txt = document.getElementById('dragged').getAttribute('datas');
			var items = eval(txt);
			if (!items){return false;}
			var comeFrom = dragged.parentNode;
			comeFrom = dragged.parentNode;
			dragged.removeAttribute('datas');
			if ( top.id != 'trash' ) {
				buildDragableElement(items ,top, before);
			}
			if ( !(top.id == comeFrom.id) ) {
				if ( top.id != 'trash' )  {
					var w = parseInt(top.style.width);
					top.style.width = w+216+'px';
					operaCorrect(w+216,top);
				}
				if ( comeFrom.id == 'show' || comeFrom.id == 'tmp' ) {
					var w = parseInt(comeFrom.style.width);
					comeFrom.style.width = w-216+'px';
					operaCorrect(w-216,comeFrom);
				}
			}
			if ( dragged && comeFrom.id != 'dir' ) {
				dragged.parentNode.removeChild(dragged);
			}
			return false;
		}
		function operaCorrect(w,top) {
			if ( window.opera ) {
				// get number of children
				var nb = top.childNodes.length;
				setDimension(nb, top);
			}
		}
		function setDimension(i, top) {
			if ( window.opera ) {
				// max allowed width 32764 ! <= 150 element
				if ( i > 150 ) {
					top.style.width = 150*216+8+'px';
					top.parentNode.style.overflowY = 'scroll';
				}
				else {
					top.style.width = i*216+8+'px';
					top.parentNode.style.overflowY = 'hidden';
				}
			}
			else {
				top.style.width = i*216+8+'px';
			}
		}
		function getDirContent() {
			var selected = document.dirForm[0].value;
			// query for directory content
			var result = sendRequestData('?getPictList='+encodeURIComponent(selected));
			if ( result != "" ) {
				var dirList = eval(result);
				var i;
				var top = document.getElementById('dir');
				// remove all sub elements
				while ( top.firstChild ) {
					top.removeChild(top.firstChild);
				}
				for ( i = 0; i < dirList.length; i++ ) {
					var str = dirList[i];
					str[0] = str[0].replace(/&39;/g,"'");
					str[1] = str[1].replace(/&39;/g,"'");
					str[2] = str[2].replace(/&39;/g,"'");
					str[3] = str[3].replace(/&39;/g,"'");
					buildDragableElement(str ,top, null);
				}
				setDimension(i, top,0);
			}
			return true;
		}
		function getFileList(element, dir,ext, select) {
			element.options.length = 0;
			var xmlHttp = new XMLHttpRequest();
			var url = 	'?getFileList='+encodeURIComponent(dir)+
						'&type='+encodeURIComponent(ext);
			var result = sendRequestData(url);
			if ( result != '' ) {
				var opt = document.createElement('option');
				if ( ext == '.ogg' )
					opt.innerHTML = 'Default';
				else
					opt.innerHTML = '';
				opt.value='';
				element.add(opt, null);
				if ( ext == '.ogg' ) {
					var opt = document.createElement('option');
					opt.value='-';
					if ( select == '-' ) {
						opt.setAttribute('selected','');
					}
					opt.innerHTML = 'Stop';
					element.add(opt, null);
				}
				var dirList = eval(result);
				var i;
				for ( i = 0; i < dirList.length; i++) {
					opt = document.createElement('option');
					opt.value = dirList[i];
					var str = dirList[i].replace('&39;',"'");
					var l = str.length;
					if ( ext == '.ogg' ) {
						str = str.slice(0,l-4);
						var delim = str.lastIndexOf('/');
						if ( delim > 0 )
							str = str.substring(delim+1, str.length);
					}
					else
						str = str.slice(0,l-5);
					l = str.length;
					if ( l > 46 ) {
						str = str.slice(l-46,l);
					}
					opt.innerHTML = str;
					if ( select == dirList[i] ) {
						opt.setAttribute('selected','');
					}
					element.add(opt, null);
				}
			}
			return;
		}
		function putNewTextToTemp(name) {
			var tmp = document.getElementById('tmp');
			var data = ['',name,'','',''];
			buildDragableElement(data ,tmp, null);
		}
 		function cancel() {
			var editObject=document.getElementById('editObject');
			if ( editObject ) {
				editObject.removeAttribute('id');
			}
			document.getElementById('textMainContainer').style.display='none';
		}
 		function doText(event,text,pict) {
			//event == null -> neue datei
			// event.type == dblclick -> show daten editieren
			// event.type == onclick  && button > 1 -> textdatei editieren
			var mode = 'none';
			if ( event ) {
				if ( event.type == 'dblclick' ) {
					mode = 'data';
				}
				if ( event.type == 'mousedown' ) {
					if ( event.which < 2 )
						return false;
					if ( pict == '' && text == '' )
						return false;
					mode = 'edit';
				}
			}
			else {
				mode = 'new';
			}

			if ( mode == 'none' || (mode == 'edit' && text == '')) {
				return false;
			}
			if ( mode == 'data' ) {
				document.getElementById('editText').style.display = 'none';
				document.getElementById('editData').style.display = 'block';
			} else {
				document.getElementById('editText').style.display = 'block';
				document.getElementById('editData').style.display = 'none';
			}

			document.getElementById('textMainContainer').style.display='block';
			document.getElementById('textMainContainer').style.height=window.innerHeight+'px';

			if ( pict == '' ) {
				document.getElementById('imgDiv').style.display = 'none';
				document.getElementById('img').removeAttribute('src');
			} else {
				document.getElementById('imgDiv').style.display = 'table-cell';
				document.getElementById('img').src='edit.php?id='+pict+'&size=680';
			}
			if ( mode == 'data' && text == '' ) {
				document.getElementById('text').style.display = 'none';
			} else {
				document.getElementById('text').style.display = 'table-cell';
			}
			if ( mode == 'new' ) {
				document.forms.textDone.textName.value=text;
				document.forms.textDone.textName.removeAttribute('readonly');
				var data = ['<h1 style="'+styleh1+'">'+title+'</h1>', '<h2 style="'+styleh2+'">'+subtitle+'</h2>'];
				ed.fillText(data);
			}
			if ( mode == 'edit' ) {
				document.forms.textDone.textName.value=text;
				document.forms.textDone.textName.setAttribute('readonly','');
				ed.showText(text);
			} else {
				if ( text != '' )
				ed.showText(text);
			}
			return false;
		}
        function saveData() {
			// read data from form
			var tname = document.editData.tname.value;
			var music = document.editData.music.value;
			var tempo = parseInt(document.editData.tempo.value);
			tempo = tempo * 1000 / waitTime;
			if ( tempo == 1 || isNaN(tempo)) { tempo = ''; }
			var obj = document.getElementById('editObject');
			if ( obj )
			{
				obj.removeAttribute('id');
				if ( tname != obj.childNodes[2].innerHTML ) {
					obj.childNodes[2].innerHTML = tname;
				}
				if ( music != obj.childNodes[3].innerHTML ) {
					obj.childNodes[3].innerHTML = music;
				}
				if ( tempo != obj.childNodes[4].innerHTML ) {
					obj.childNodes[4].innerHTML = tempo;
				}
			}
			cancel();
		}
        function edit(event) {
			// show the data for the double clicked picture/text
			// and allow to enter a music command and possibly
			// add a text file if this is a picture
			// fill elements
			if ( !(this.parentNode.id == 'show' || this.parentNode.id == 'tmp' )) {
				return;
			}
			var list = buildItemsString(this);
			list = eval(list);
			if ( this.parentNode.id == 'dir' &&  list[0] != '' ) {
				return;
			}
			if ( this.parentNode.id == 'dir' ) {
				// edit mode for text file, don't show the normal form
				list[0] = '';
			}
			// fill the input/options fields
			document.editData.tempo.value = list[3];

			var elem = document.getElementById('tname');
			// remove all options
			elem.options.length = 0;
			if ( list[0] == '' ) { /* only a text */
				var opt = document.createElement('option');
				opt.innerHTML = list[1];
				elem.add(opt, null);
			} else {
				getFileList(elem,'textes','.html',list[1]);
			}
			elem = document.getElementById('music');
			// remove all options
			elem.options.length = 0;
			getFileList(elem,'music','.ogg',list[2]);
			// remember which object
			this.setAttribute('id','editObject');
			// and call the editor window
			doText(event,list[1],list[0])
		}

function setMode() {
	var ele = document.querySelector('html');
	if ( ele ) {
		/* remove class */
		if ( ele.getAttribute('mode') == "dark") {
			ele.setAttribute("mode","light");
			localStorage.setItem("mode", "light");
		} else {
			ele.setAttribute("mode","dark");
			localStorage.setItem("mode", "dark");
		}
	}
}
function initMode() {
	var setDark=false;
	var x = window.matchMedia("(prefers-color-scheme: dark)");
	if ( x && x.matches ) {
		setDark=true;
	}
	var mode = localStorage.getItem("mode");  /* set if present */
	if ( mode == 'light' ) {
		setDark=false;
	} else if ( mode =='dark') {
		setDark=true;
	}
	if ( setDark )  {
		var ele= document.querySelector('html');
		ele.setAttribute("mode", "dark");
		localStorage.setItem("mode", "dark");
	} else {
		var ele= document.querySelector('html');
		ele.setAttribute("mode","light");
		localStorage.setItem("mode", "light");
	}
}
