<?php
	$fontDir = 'textes/fonts';
	$fileName = 'list.js';
	$lang=substr($_SERVER['HTTP_ACCEPT_LANGUAGE'],0,2);
	$fontdir="";
	$importopt="";
	include("data/globalfunc.php");
	include("config.php");
	if ( $fontdir != "" ) {
		if ($fontdir[0]) {
			$fontDir = $root.$fontdir;
		} else {
			$fontDir = $fontdir;
		}
	}
	include("data/dir-file.php");
	if ( !file_exists("list.js") ) {
		$fd = fopen("list.js","w");
		fwrite($fd,"var fileList = [ ];");
		fclose($fd);
	}
	if ( !is_dir("textes") ) {
		mkdir('textes');
	}
	if ( !is_dir("music") ) {
		mkdir('music');
	}
	if (isset($_GET) ) {
		if ( isset($_GET['read']) ) {
			readJs($_GET['read']);
			return;
		}
		if ( isset($_GET['id']) ) {
			getImage($_GET['id'], $_GET['size']);
			return;
		}
		if ( isset($_GET['list']) ) {
			writeList($fileName, $_GET['list']);
			return;
		}
		if ( isset($_GET['open']) ) {
			buildList($fileName, 'open', $_GET['open']);
			return;
		}
		if ( isset($_GET['append']) ) {
			buildList($fileName, 'append', $_GET['append']);
			return;
		}
		if ( isset($_GET['close']) ) {
			buildList($fileName, 'close', $_GET['close']);
			return;
		}
		if ( isset($_GET['getPictList']) ) {
			getPictList($_GET['getPictList']);
			return;
		}
		if ( isset($_GET['getFileList']) ) {
			getFileList($_GET['getFileList'],$_GET['type']);
			return;
		}
		if ( isset($_GET['file']) ) {
			getTextStyle($_GET['file']);
			return;
		}
		if ( isset($_GET['save']) ) {
			saveText($_GET['save'],$_GET['title'],$_GET['css1'],$_GET['subtitle'],$_GET['css2'],$fontdir);
			return;
		}
		if ( isset($_GET['fontList']) ) {
			echo getFontlist($fontDir);
			return;
		}
		if ( isset($_GET['show']) ) {
			readfile("diashow.html");
			return;
		}
	}

	if (isset($_POST) && isset($_POST['action']))
		$action = $_POST['action'];
	else if (isset($_GET) && isset($_GET['action']))
		$action = $_GET['action'];
	else
		$action='';

	switch($action) {
		case "doExport":
			doExport($root, $_POST['target']);
			return;
		break;
		case "doImport":
			doImport($root, $_POST['source'],$importopt);
			return;
		break;
		case "getImgFiles":
			getImgFiles($root,'');
			return;
		break;
		case "makeDir":
			makeDir($root, $_POST['name']);
			return;
		break;
		case "saveHtml":
			saveHtml($root, $_POST['name']);
			return;
		break;
		case "loadHtml":
			loadHtml($root, $_POST['name']);
			return;
		break;
		case "getDirList":
			getDirList($root,$_POST['dir'],$_POST['subDir']);
			return;
		break;
		case "uploadImg":
			uploadImg($root, $_POST['dir'],$_POST['name'], $_POST['image'] );
			return;
		break;
		case "getDirHtml":
			getDirHtml($root, $_POST['dir']);
			return;
		break;
		case "deleteObj":
			deleteObj($root,$_POST['name']);
			return;
		break;
		case "moveObj":
			moveObj($root,$_POST['old'], $_POST['new']);
			return;
		break;
	}
?>
<!DOCTYPE html>
<html lang="<?php echo $lang;?>" mode="light">
<head>
	<title>Dia-Show Editor</title>
	<meta name="language" content="German"/>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=320, height=160, initial-scale=0.5" />
	<link rel="stylesheet" type="text/css" href="data/main.css">
	<link rel="stylesheet" type="text/css" href="data/operaDragAndDrop.css">
	<script type="text/javascript" src="data/jscolor.js"></script>
	<script type="text/javascript" src="data/operaDragAndDrop.js"></script>
	<link rel="stylesheet" type="text/css" href="data/fd-slider.css" />
	<link rel="stylesheet" type="text/css" href="data/fd-slider-tooltip.css" />
	<script type="text/javascript" src="data/fd-slider.js"></script>
	<script type="text/javascript" src="data/ed.js"></script>
	<script type="text/javascript" src="data/setlang.js"></script>
	<script type="text/javascript" src="data/lang/languages.js"></script>
	<script type="text/javascript" src="data/ped.js"></script>
	<style type="text/css">
		<?php echo buildFontFace($fontDir); ?>
	</style>
	<script type="text/javascript" src="data/main.js"></script>
</head>
<body oncontextmenu="return false;" onresize="setMainHeight()">
	<div id="mainDiv" style="height:800px;visibility:visible">
		<form name="dirForm">
			<select>
				<?php getDirOptions('.', '');?>
			</select>
			<input id="dirContent" type="button" onclick="getDirContent()" value="Bilder aus gewählte Verzeichnis holen">
			<select id="languages" onchange="setLang(event,this.value)">
				<option value="de">Deutsch</option>
				<option value="en">English</option>
				<option value="fr">Français</option>
			</select>
			<input id="bw" type="button" onclick="setMode()" style="visibility: visible;float:right;" value="&bull;">
		</form>
		<div id="dirTop" style="overflow-y:hidden;">
			<div id="dir" class="show"
				style="width:224px;">
			</div>
		</div>
		<!-- style don´t work within style sheet, google-chrome, firefox! -->
		<div id="trashTop" style="background-image:url(data/xfce-trash_full.png);background-size:200px;background-position: center;background-repeat:no-repeat";>
			<div id="trash" class="cell"
				ondrop="return dragDrop(event)" 
				ondragover="return dragOver(event)">
			</div>
		</div>
		<div id="tmpTop" style="overflow-y:hidden;">
			<div id="tmp" class="show"
				ondrop="return dragDrop(event);" 
				ondragover="return dragOver(event);" 
				style="width:224px;">
			</div>
		</div>
		<div style="clear:both"></div>
		<div id="showTop" style="overflow-y:hidden;">
			<div id="show" class="show" style="width:800px"></div>
		</div>
		<input id="makeList" type="button" value="Dateiliste erzeugen" onclick="saveList();"></input>
		<input id="newTextFile" type="button" value="Neue Textdatei erzeugen" onclick="doText(null,'','');"></input>
		<span id="tip1" class="tip"> Daten editieren: Doppelclick </span>&nbsp;&nbsp;&nbsp;&nbsp; <span id="tip2" class="tip"> Texte editieren: Click Rechts </span>
		<a id="test" href="?show" target="_blank">Test</a>
		<input id="export" type="button" value="Diashow Exportieren" onclick="ped.showServerDialog('export');"></input>
		<?php include("data/menu.html");?>
		<input id="clean" type="button" value="Neue Diashow" onclick="newDia();"></input>
		<input id="import" type="button" value="Diashow importieren" onclick="ped.showServerDialog('import');">
	</div>
<?php include("data/ed.html");?>
	<div style="display:none">
		<div id="noFileName"></div>
	</div>
	<div id='overlay'></div>
</body>
</html>

